function [xcs, ycs, xcd, ycd] = casing(tup, tdown, xO, R)
%This function is for plotting casing internal profile (circular portion),
%for both sides (driven and driver gear)
%INPUT
%tup : casing angular extension, delivery side [deg]
%tdown : casing angular extension, suction side [deg]
%xO : wheel center x coordinatew/ respect to center of wheelbase
%R : citrcle radius (internal gear profile)
%OUTPUT
%xcs, ycs : vectors containing casing profile points (driver gear side)
%xcs, ycs : vectors containing casing profile points (driven gear side)

tup = pi - deg2rad(tup); tdown = pi + deg2rad(tdown);
th = linspace( tup, tdown, 300);
xcs = R*cos(th) + xO; ycs = R*sin(th);
xcd = - xcs; ycd = ycs;

end